/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.integrator;

import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.apps.taskman.integrator.VWManagerNode;
import filenet.vw.apps.taskman.integrator.VWManagerPropertyPanel;
import filenet.vw.apps.taskman.integrator.resources.VWResource;
import filenet.vw.toolkit.utils.VWHelp;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class VWJavaSecurityPanel
extends VWTaskTabPanel
implements ActionListener {
    protected static String JAVA_SECURITY_AUTH_LOGIN_CONFIG = "java.security.auth.login.config";
    protected static String JAVA_SECURITY_POLICY = "java.security.policy";
    protected static String JAVA_SECURITY_MANAGER = "java.security.manager";
    VWManagerNode m_node = null;
    JTextField m_loginConfig = null;
    JTextField m_securityPolicy = null;
    JTextField m_securityManager = null;
    JButton m_showCommand = new JButton(VWResource.ShowCommand);

    public VWJavaSecurityPanel(VWManagerNode node) {
        this.m_node = node;
        this.initLayout();
    }

    public void validateTextFields() throws VWException {
        String fileName = this.m_loginConfig.getText();
        if (!new File(fileName).exists()) {
            throw new VWException("filenet.vw.apps.taskman.cm.VWJavaSecurityPanel.FileNotFound", "{0} is not found", fileName);
        }
        fileName = this.m_securityPolicy.getText();
        if (!new File(fileName).exists()) {
            throw new VWException("filenet.vw.apps.taskman.cm.VWJavaSecurityPanel.FileNotFound", "{0} is not found", fileName);
        }
    }

    protected void applyProperties() throws VWException {
        this.m_node.setLoginConfig(this.m_loginConfig.getText());
        this.m_node.setSecurityManager(this.m_securityManager.getText());
        this.m_node.setSecurityPolicy(this.m_securityPolicy.getText());
    }

    protected void resetProperties() {
        this.m_loginConfig.setText(this.m_node.getLoginConfig());
        this.m_securityManager.setText(this.m_node.getSecurityManager());
        this.m_securityPolicy.setText(this.m_node.getSecurityPolicy());
    }

    protected void updateState(boolean enabled) {
        this.m_loginConfig.setEditable(enabled);
        this.m_securityPolicy.setEditable(enabled);
        this.m_securityManager.setEditable(enabled);
    }

    private void initLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 21;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 10, 5, 5);
        this.m_loginConfig = new JTextField("");
        this.m_loginConfig.setName(JAVA_SECURITY_AUTH_LOGIN_CONFIG);
        this.m_loginConfig.addFocusListener(this);
        this.add((Component)new JLabel(this.m_loginConfig.getName() + ":"), c);
        ++c.gridy;
        this.m_securityPolicy = new JTextField("");
        this.m_securityPolicy.setName(JAVA_SECURITY_POLICY);
        this.m_securityPolicy.addFocusListener(this);
        this.add((Component)new JLabel(this.m_securityPolicy.getName() + ":"), c);
        ++c.gridy;
        this.m_securityManager = new JTextField("");
        this.m_securityManager.setName(JAVA_SECURITY_MANAGER);
        this.m_securityManager.addFocusListener(this);
        this.add((Component)new JLabel(this.m_securityManager.getName() + ":"), c);
        ++c.gridx;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.add((JTextComponent)this.m_loginConfig, (Object)c, false);
        ++c.gridy;
        this.add((JTextComponent)this.m_securityPolicy, (Object)c, false);
        ++c.gridy;
        this.add((JTextComponent)this.m_securityManager, (Object)c, false);
        if (VWManagerPropertyPanel.AdvancedMode) {
            ++c.gridy;
            this.m_showCommand.addActionListener(this);
            this.add((Component)this.m_showCommand, c);
        }
        this.resetProperties();
        this.setValidationEnabled(true);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.m_showCommand) {
            this.m_node.getTaskCore().displayInformation(this.m_node.getFullCommandLine());
            return;
        }
    }

    public String getHelpPage() {
        return VWHelp.Help_Process_TaskManager + "cm_config_java.htm";
    }
}

